#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <map>
#include <string>
#include <unordered_map>
#include <unordered_set>

struct block
{
	// index - value
	std::vector<std::pair<int, int>> e;
	std::vector<int> n;
};

template<typename T>
inline bool contains(const std::vector<T>& v, T val)
{
	return std::find(v.begin(), v.end(), val) != v.end();
}

int main()
{
	int n, m;
	std::cin >> n >> m;
	std::vector<block> b(n);
	std::vector<int> a(n * m);
	for (auto& v : a)
	{
		std::cin >> v;
	}
	int r = 0;
	for (int i = 0; i < n; i++)
	{
		auto& bb = b[i];
		for (int v = 1; v <= m; v++)
		{
			bool f = false;
			for (int j = 0; j < m; j++)
			{
				if (a[i * m + j] == v)
				{
					if (f)
						bb.e.emplace_back(j, v);
					f = true;
				}
			}
			if (!f)
				bb.n.push_back(v);
		}
		r += bb.n.size();
	}

	if (r == 0)
	{
		std::cout << 0 << std::endl;
		return 0;
	}
	std::cout << r + 1 << std::endl;
	int cur_free_slot_block = 0;
	int cur_free_slot_subindex = 0;
	int cur_free_slot_requirement = 0;
	for (int i = 0; i < b.size(); i++)
	{
		if (!b[i].e.empty())
		{
			auto e = b[i].e.back();
			b[i].e.pop_back();
			auto nn = b[i].n.back();
			b[i].n.pop_back();
			cur_free_slot_block = i;
			cur_free_slot_subindex = e.first;
			cur_free_slot_requirement = nn;

			std::cout << cur_free_slot_block * m + cur_free_slot_subindex + 1 << ' ' << n * m + 1 << std::endl;
			
			break;
		}
	}

	while (r - 1)
	{
		for (int i = 0; i < b.size(); i++)
		{
			auto& bb = b[i];
			auto pr = [&](const std::pair<int, int>& el) { return el.second == cur_free_slot_requirement; };
			auto ff = std::find_if(bb.e.begin(), bb.e.end(), pr);
			if (ff != bb.e.end())
			{
				auto e = *ff;
				bb.e.erase(ff);
				std::cout << i * m + e.first + 1 << ' ' << cur_free_slot_block * m + cur_free_slot_subindex + 1 << std::endl;
				auto nn = bb.n.back();
				bb.n.pop_back();
				cur_free_slot_block = i;
				cur_free_slot_subindex = e.first;
				cur_free_slot_requirement = nn;
			}
		}
		r--;
	}

	std::cout << n * m + 1 << ' ' << cur_free_slot_block * m + cur_free_slot_subindex + 1 << std::endl;
}
